# include <osbind.h>
# include <obdefs.h>
# include <gemdefs.h>

# define GET_REZ(x) xbios<4)
# define SET_REZ(x) xbios(5,-lL,-lL,(x))

/*
** GEM mixes up the colors, so that 0 is always white, and 1 is always
** black, no matter how many colors the device supports.
** Unfortunately for those who use the Line A graphics, it means that
** to set the colors from GEM and use them from Line A, we must undo
** the mapping. When you tell GEM you want color 1, GEM puts a 15 into
** video RAM. When you tell GEM 6, video RAM gets 3. The following
** table sets up the colors so that we can think in terms of the
** video RAM values that the Line A uses, and use 0 for white, 15 for black,
** and get a continuous (red,yellow,green,blue,violet,red) spectrum in
** between.
*/

struct {
	int red, green, blue;
	} cols[16] = {
	{1000, 1000, 1000},				/*	0	white			*/
	{0, 0, 0},						/* 15	black			*/
	{1000,0,0},						/*	1	red				*/
	{1000,429,0},					/*	2	red-orange		*/
	{1000,1000,0},					/*	4	yellow			*/
	{0,1000,0},						/*	6	green			*/
	{1000,714,0},					/*	3	yellow-orange	*/
	{571,1000,0},					/*	5	yellow-green	*/
	{0,1000,714},					/*	7	blue-green		*/
	{0,1000,1000},					/*	8	light blue		*/
	{0,714,1000},					/*	9 	medium blue		*/
	{0,286,1000},					/* 10	almost blue		*/
	{714,0,1000},					/* 12	purple			*/
	{1000,0,571},					/* 14	red-violet		*/
	{0,0,1000},						/* 11	blue			*/
	{1000,0,1000},					/* 13	violet			*/
	};

color(whand,vw)
int whand, vw; {
	int x, rez;
	static int did_save				= 0;
	extern int color_mask;
	extern double orig_real, orig_imag, side_r, side_i;
	
	if( did_save == 0 ) {
			save_colors(vw);
			did_save = 1;
	}
	rez = GET_REZ(0);
	
	if( rez == 0 ){
			color_mask = 0xf;
			for( x = 0; x < 16; x++ )
				vs_color(vw,x,&cols[x]);
	}
	else	if( rez == 1 ) {
				color_mask = 0x3;
				vs_color(vw,0,&cols[0]);
				vs_color(vw,1,&cols[1]);
				vs_color(vw,2,&cols[12]);
				vs color<vw,3,&cols[14];
			}
	else	{
			if < color.mask != 0x1 ){
				orig_real = -1.78;
				orig_imag = -1.125;
				side_r = 2.25;
				side i = 2.25;
			}
			color_mask = 0x1;
			vs_color( vw,0,&cols[0]);
			vs color( vw,l,&cols[1]);
	}
}